// AISingleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AISingle.h"
#include "AISingleDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAISingleDlg dialog

CAISingleDlg::CAISingleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAISingleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAISingleDlg)
	m_result = _T("");
	m_deviceNumber = 0;
	m_gainMethod = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAISingleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAISingleDlg)
	DDX_Control(pDX, IDC_Sample, m_SampleButton);
	DDX_Text(pDX, IDC_Result, m_result);
	DDX_Text(pDX, IDC_DEVICE, m_deviceNumber);
	DDV_MinMaxUInt(pDX, m_deviceNumber, 0, 5);
	DDX_Check(pDX, IDC_GAIN, m_gainMethod);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAISingleDlg, CDialog)
	//{{AFX_MSG_MAP(CAISingleDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_INIT, OnInit)
	ON_BN_CLICKED(IDC_Sample, OnSample)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_EXIT, OnExit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAISingleDlg message handlers

BOOL CAISingleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	// set our pointers equal to something
	m_pSR=NULL;
    m_driverInstance=NULL;
	m_deviceNumber = 0;
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAISingleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAISingleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAISingleDlg::OnInit() 
{
   // Open the driver and Initialize the hardware


m_driverInstance=OpenDriverLINX(m_hWnd,"kdastc$"); //Open DriverLINX driver
// pass in driver name to avoid the dialog box to pick a driver
// append $ onto end to suppress Open Driver dialog on fail
m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
UpdateData(TRUE);
m_pSR->device=m_deviceNumber; //set the device number to the device being used
m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application
//Execute the initialize service
 //show any errors	

if (DriverLINX(m_pSR) == NoErr)
{
	// success
m_SampleButton.EnableWindow(TRUE);  // enable the Sample button
}
else
{  // problem has occured
showMessage(m_pSR);  // display the error message box
}
CWnd::SetActiveWindow();
	
}

void CAISingleDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
	return;
}

void CAISingleDlg::OnSample() 
{
	clearBuffers();  // dispose of any buffer that might exist

	// setup a single channel, polled mode AI task
	m_pSR->device = m_deviceNumber;
	m_pSR->hWnd = m_hWnd;
	m_pSR->mode = POLLED;
	m_pSR->operation = START;
	m_pSR->subsystem = AI;
	m_pSR->start.typeEvent = COMMAND;
	m_pSR->stop.typeEvent = TCEVENT;
	m_pSR->timing.typeEvent = NULLEVENT;
	m_pSR->channels.numberFormat = tNATIVE;
	m_pSR->channels.nChannels = 1;  // only a start channel will be specified
	m_pSR->channels.chanGain[0].channel = 0;
	
	UpdateData(TRUE);  // get current state of the check box
	if (m_gainMethod == TRUE)
	{
		m_pSR->channels.chanGain[0].gainOrRange = 0;
	}
	else
	{
		// over-ride any setting in DLinx Config Panel
		m_pSR->channels.chanGain[0].gainOrRange =  -32768 + 7 + 8192 + 0x2^14 + (2 * 64);
                                           // type J + CJC + C or F + avg 2 per report 
	}
		/*
		
		Pass in a gain of 0 if you want the settings in the DriverLINX
		Configuration Panel (Special button) to be used, e.g., what 
		T/C type, units, use CJC or not, how many samples to average
		per reported reading.

		Or you can programatically set these values with a complex
		use of the gain field:

     -32768 + 5 = B Type T/C Sensor
     -32768 + 6 = E Type T/C Sensor
     -32768 + 7 = J Type T/C Sensor
     -32768 + 8 = K Type T/C Sensor
     -32768 + 9 = R Type T/C Sensor
     -32768 + 10 = S Type T/C Sensor
     -32768 + 11 = T Type T/C Sensor
     -32768 + 13 = N Type T/C Sensor

     1x2^13 = 8192 = CJC On
     0x2^13 = 0 = CJC Off

     1x2^14 = 16384 = report in deg F
     0x2^14 = 0 = report in deg C

     n*2^6 = n*64 = average n measurements with each reported reading

    */
	

	// allocate a single sample buffer to hold our data
	m_pSR->lpBuffers=(DL_BUFFERLIST*) new BYTE[DL_BufferListBytes(1)]; //create a buffer list pointer for one buffer
	m_pSR->lpBuffers->bufferSize=Samples2Bytes(0,AI,0,1); //set the size of the buffer (in bytes) to hold the number of samples
	// we want to acquire a buffer of data
	m_pSR->lpBuffers->notify=NULL; //do not need to enable the buffer filled message since POLLED mode
	m_pSR->lpBuffers->nBuffers=1; //use only one buffer
	m_pSR->lpBuffers->BufferAddr[0]=BufAlloc(GBUF_POLLED,m_pSR->lpBuffers->bufferSize); //Allocate Buffer 0 based on the size we just specified
	
	if (DriverLINX(m_pSR) == NoErr)
	{  // success
	float *readings;
	readings = new float[1]; //make a temporary array to hold the converted readings
	
	/*The convert operation used here is taking advantage of the fact
	that the logical device number and the subsystem (AI) have already
	been set in the start request*/
	m_pSR->operation=CONVERT; //Use the convert operation to convert the raw counts in the buffer to voltages
	m_pSR->mode=OTHER;  //Convert is not a polled, interrupt, or DMA operation
	m_pSR->start.typeEvent=DATACONVERT; //Set the start type to convert the data
	m_pSR->start.u.dataConvert.startIndex=0; //start at index 0 of the buffer
	m_pSR->start.u.dataConvert.nSamples=1; //set the number of samples to convert
	m_pSR->start.u.dataConvert.numberFormat=tSINGLE; //convert the counts to tSINGLE (float)
	m_pSR->start.u.dataConvert.scaling=0.0f; //no scaling will be used
	m_pSR->start.u.dataConvert.offset=0.0f; //no offset will be applied
	m_pSR->start.u.dataConvert.wBuffer=0; //convert DriverLINX buffer 0, since that's the only one being used
	m_pSR->start.u.dataConvert.lpBuffer=readings; //put the converted readings in the temporary buffer
	DriverLINX(m_pSR); //Execute the conversion

	m_result.Format("%8.3f",readings[0]);
	UpdateData(FALSE); // update the Dialog

	}
    else
	{  // problem has occured
     showMessage(m_pSR);  // display the error message box
	}

	
}

void CAISingleDlg::OnClose() 
{
// TODO: Add your message handler code here and/or call default
	


	CDialog::OnClose();
}

void CAISingleDlg::OnExit() 
{
		// code to clean up after DriverLINX
	clearBuffers();  // dispose of our 1 point buffer
	CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
	m_driverInstance=NULL; //make sure m_driverInstance isn't pointing to anything
	delete(m_pSR); //de-allocate the memory used by the service request
	m_pSR=NULL;

	CDialog::DestroyWindow();
	
}


void CAISingleDlg::clearBuffers()
{
	/*Make sure the service request exists first, otherwise bad things
	happen if we try to act on a pointer which may be pointing anywhere*/
	if(m_pSR!=NULL)
	{
		/*If the service request exists, make sure there is a buffer list,
		for the same reason*/
		if(m_pSR->lpBuffers!=NULL)
		{
			/*If the buffer list exists, is there actually a pointer to
			a buffer?*/
			if(m_pSR->lpBuffers->BufferAddr[0]!=NULL)
			{
				/*De-allocate the buffer, and clear its pointer*/
				BufFree(m_pSR->lpBuffers->BufferAddr[0]);
				m_pSR->lpBuffers->BufferAddr[0]=NULL;
			}
			/*Delete the buffer list, we don't need it anymore*/
			delete(m_pSR->lpBuffers); 
			m_pSR->lpBuffers=NULL;
		}
	}
}